/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.interfaces.AnvilScreenHandlerExtended;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu
implements AnvilScreenHandlerExtended {
    private List<AnvilRecipe> bcl_recipes = Collections.emptyList();
    private AnvilRecipe bcl_currentRecipe;
    private DataSlot anvilLevel;
    @Shadow
    private int f_39000_;
    @Final
    @Shadow
    private DataSlot f_39002_;

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    public void be_initAnvilLevel(int syncId, Inventory inventory, ContainerLevelAccess context, CallbackInfo info) {
        this.anvilLevel = this.m_38895_(DataSlot.m_39401_());
        if (context != ContainerLevelAccess.f_39287_) {
            int level = (Integer)context.m_39299_((world, blockPos) -> {
                Block anvilBlock = world.m_8055_(blockPos).m_60734_();
                return LeveledAnvilBlock.getAnvilCraftingLevel(anvilBlock);
            }, (Object)0);
            this.anvilLevel.m_6422_(level);
        } else {
            this.anvilLevel.m_6422_(0);
        }
    }

    @Shadow
    public abstract void m_6640_();

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bcl_canTakeOutput(Player player, boolean present, CallbackInfoReturnable<Boolean> info) {
        if (this.bcl_currentRecipe != null) {
            info.setReturnValue((Object)this.bcl_currentRecipe.checkHammerDurability(this.f_39769_, player));
        }
    }

    @Inject(method={"lambda$onTake$2(Lnet/minecraft/world/entity/player/Player;FLnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bcl_onDamageAnvil(Player player, float adapter_injected_1, Level level, BlockPos blockPos, CallbackInfo ci) {
        Block block;
        BlockState blockState = level.m_8055_(blockPos);
        if (!player.m_150110_().f_35937_ && (block = blockState.m_60734_()) instanceof BaseAnvilBlock) {
            BaseAnvilBlock anvil = (BaseAnvilBlock)block;
            if (player.m_217043_().m_188500_() < 0.12) {
                BlockState damaged = anvil.damageAnvilUse(blockState, player.m_217043_());
                BaseAnvilBlock.destroyWhenNull(level, blockPos, damaged);
                ci.cancel();
            }
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bcl_onTakeAnvilOutput(Player player, ItemStack stack, CallbackInfo info) {
        if (this.bcl_currentRecipe != null) {
            int ingredientSlot = AnvilRecipe.getIngredientSlot(this.f_39769_);
            this.f_39769_.m_8020_(ingredientSlot).m_41774_(this.bcl_currentRecipe.getInputCount());
            stack = this.bcl_currentRecipe.craft(this.f_39769_, player);
            this.m_6199_(this.f_39769_);
            this.f_39770_.m_39292_((level, blockPos) -> {
                BlockState anvilState = level.m_8055_(blockPos);
                Block anvilBlock = anvilState.m_60734_();
                if (anvilBlock instanceof BaseAnvilBlock) {
                    BaseAnvilBlock anvil = (BaseAnvilBlock)anvilBlock;
                    if (!player.m_150110_().f_35937_ && anvilState.m_204336_(BlockTags.f_13033_) && player.m_217043_().m_188500_() < 0.1) {
                        BlockState damagedState = anvil.damageAnvilUse(anvilState, player.m_217043_());
                        BaseAnvilBlock.destroyWhenNull(level, blockPos, damagedState);
                    } else {
                        level.m_46796_(1030, blockPos, 0);
                    }
                }
            });
            info.cancel();
        }
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void bcl_updateOutput(CallbackInfo info) {
        RecipeManager recipeManager = this.f_39771_.m_9236_().m_7465_();
        this.bcl_recipes = recipeManager.m_44056_(AnvilRecipe.TYPE, this.f_39769_, this.f_39771_.m_9236_());
        if (this.bcl_recipes.size() > 0) {
            int anvilLevel = this.anvilLevel.m_6501_();
            this.bcl_recipes = this.bcl_recipes.stream().filter(recipe -> anvilLevel >= recipe.getAnvilLevel()).collect(Collectors.toList());
            if (this.bcl_recipes.size() > 0) {
                if (this.bcl_currentRecipe == null || !this.bcl_recipes.contains(this.bcl_currentRecipe)) {
                    this.bcl_currentRecipe = this.bcl_recipes.get(0);
                }
                this.bcl_updateResult();
                info.cancel();
            } else {
                this.bcl_currentRecipe = null;
            }
        }
    }

    @Inject(method={"setItemName"}, at={@At(value="HEAD")}, cancellable=true)
    public void bcl_setNewItemName(String string, CallbackInfoReturnable<Boolean> cir) {
        if (this.bcl_currentRecipe != null) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.be_previousRecipe();
            return true;
        }
        if (id == 1) {
            this.be_nextRecipe();
            return true;
        }
        return super.m_6366_(player, id);
    }

    private void bcl_updateResult() {
        if (this.bcl_currentRecipe == null) {
            return;
        }
        this.f_39768_.m_6836_(0, this.bcl_currentRecipe.m_5874_(this.f_39769_, this.f_39771_.m_9236_().m_9598_()));
        this.m_38946_();
    }

    @Override
    public void bcl_updateCurrentRecipe(AnvilRecipe recipe) {
        this.bcl_currentRecipe = recipe;
        this.bcl_updateResult();
    }

    @Override
    public AnvilRecipe bcl_getCurrentRecipe() {
        return this.bcl_currentRecipe;
    }

    @Override
    public List<AnvilRecipe> bcl_getRecipes() {
        return this.bcl_recipes;
    }
}

